import {
  applyMiddleware,
  Store,
  combineReducers,
  compose,
  createStore
} from 'redux';
import thunk from 'redux-thunk';
import reduxLogger from 'redux-logger';
 
// import { myReducer } from './reducers/my-reducer';
import conceptSearch from './reducers/concept-search.reducers';
import conceptNode from './reducers/concept-node.reducers';
import conceptCard from './reducers/concept-card.reducers';
import bookmark from './reducers/bookmark.reducers';
import sideNavigation from './reducers/side-navigation.reducers';
import system from './reducers/system.reducers';
import conceptTemplate from './reducers/concept-templating.reducers';
import concepts from './reducers/concepts.reducers';


export interface IAppState {
  bookmark: any;
  conceptCard: any;
  conceptNode: any;
  conceptSearch: any;
  system: any;
  sideNavigation: any;
  conceptTemplate: any;
  concepts: any;
}

// export const INITIAL_STATE: IAppState = {
//   environment: {},
//   concepts: [],
//   activeIcon: 'search',
//   searched: false,
//   searching: false,
//   selectedConcept: {},
//   conceptCardData: {},
//   allowableTabSelection: [
//     'description',
//     'relationships',
//     'metadata',
//     'mvp'
//   ],
//   conceptCardState: {
//     selectedTab: 'description'
//   },
//   conceptHistory: [],
//   displayCard: false,
//   cardPopulating: false,
//   cardPopulated: false,
//   canViewConceptCard: true,
//   canViewNode: false,
//   bookmarks: [],
//   selectedBookmark: {},
//   currentFilterTag: {},
//   filteredBookmarks: [],
//   mvpRemoving: false,
//   conceptSearchData: {},
//   maxConceptSearchPages: 10,
//   canConceptSearchLastButton: true,
//   canConceptSearchFirstButton: false,
//   canConceptSearchNextButton: true,
//   canConceptSearchPreviousButton: false,
//   mvpAddState: {
//     canAddDef: true,
//     isAddingDef: false,
//     canAddAltDef: true,
//     isAddingAltDef: false,
//     canAddSyn: true,
//     isAddingSyn: false
//   }
// };
 
const rootReducer = combineReducers({
  bookmark,
  conceptCard,
  conceptNode,
  conceptSearch,
  system,
  sideNavigation,
  conceptTemplate,
  concepts,
});
 
export const store = createStore(
  rootReducer,
  compose(
    applyMiddleware(
      thunk,
      reduxLogger
    )
  )
) as Store<IAppState>;
